<?php
// /ai/water-mold.php
$siteName  = "WhataShine Logistics";
$pageTitle = "Water & Mold Restoration";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?php echo $siteName; ?> | <?php echo $pageTitle; ?></title>

  <!-- Favicon (update filename if needed) -->
  <link rel="icon" type="image/png" href="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png">

  <style>
    :root{
      --blue:#0b5fff;
      --navy:#0b2b5b;
      --bg:#f3f6fb;
      --card:#ffffff;
      --muted:#4a5b77;
      --line:#e6edf7;
      --soft:#eef4ff;
      --shadow: 0 10px 30px rgba(0,0,0,.07);
      --radius: 16px;
      --danger:#e11d48;
      --warn:#f59e0b;
      --ok:#16a34a;
    }
    *{ box-sizing:border-box; }
    body{
      margin:0;
      font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Arial,sans-serif;
      background:var(--bg);
      color:var(--navy);
    }
    .wrap{ max-width:1100px; margin:18px auto 40px; padding:0 14px; }
    .shell{
      background:var(--card);
      border-radius:18px;
      box-shadow:var(--shadow);
      overflow:hidden;
      border:1px solid var(--line);
    }

    /* Topbar */
    .topbar{
      display:flex;
      justify-content:space-between;
      align-items:center;
      padding:14px 16px;
      gap:12px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      border-bottom:1px solid var(--line);
    }
    .brand{
      display:flex;
      align-items:center;
      gap:10px;
      text-decoration:none;
      min-width:220px;
    }
    .brand img{ height:42px; width:auto; display:block; }
    .brand span{
      font-weight:900;
      color:var(--navy);
      font-size:18px;
      white-space:nowrap;
    }
    .nav{ display:flex; gap:10px; align-items:center; }
    .btn{
      border:1px solid var(--line);
      background:#fff;
      padding:10px 14px;
      border-radius:14px;
      text-decoration:none;
      font-weight:800;
      color:var(--navy);
      display:inline-flex;
      align-items:center;
      gap:8px;
    }
    .btn.primary{
      background:var(--blue);
      color:#fff;
      border-color:transparent;
    }

    .banner{
      text-align:center;
      padding:10px 14px;
      background:var(--soft);
      font-weight:900;
      color:var(--navy);
      border-bottom:1px solid var(--line);
    }
    .banner small{
      display:block;
      font-weight:800;
      color:var(--muted);
      margin-top:2px;
    }

    /* Hero */
    .hero{ padding:22px 18px 8px; text-align:center; }
    .hero h1{ margin:10px 0 6px; font-size:40px; letter-spacing:-.5px; }
    .hero p{ margin:0; color:var(--muted); font-weight:600; }

    /* Alerts row */
    .alerts{
      max-width:920px;
      margin:14px auto 0;
      padding:0 10px;
      display:grid;
      grid-template-columns:repeat(3,1fr);
      gap:10px;
    }
    .alert{
      border:1px solid var(--line);
      background:#fff;
      border-radius:16px;
      padding:12px 14px;
      text-align:left;
      box-shadow:0 10px 22px rgba(0,0,0,.04);
    }
    .alert .tag{
      display:inline-block;
      font-size:12px;
      font-weight:900;
      padding:6px 10px;
      border-radius:999px;
      color:#fff;
      margin-bottom:8px;
    }
    .tag.danger{ background:var(--danger); }
    .tag.warn{ background:var(--warn); color:#1f2937; }
    .tag.ok{ background:var(--ok); }
    .alert .t{ font-weight:900; margin-bottom:4px; }
    .alert .d{ color:var(--muted); font-weight:600; font-size:13px; }

    /* Chat */
    .chat{ max-width:920px; margin:16px auto 6px; padding:0 10px; }
    .chat-row{ display:flex; gap:10px; align-items:stretch; }
    .chat-row input{
      flex:1;
      border:1px solid var(--line);
      border-radius:16px;
      padding:16px;
      font-size:16px;
      outline:none;
    }
    .chat-row button{
      min-width:120px;
      border:0;
      border-radius:16px;
      background:var(--blue);
      color:#fff;
      font-weight:900;
      cursor:pointer;
      padding:16px 18px;
    }

    .chips{
      display:flex;
      gap:10px;
      flex-wrap:wrap;
      justify-content:center;
      padding:12px 0 0;
    }
    .chip{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:10px 14px;
      font-weight:900;
      color:var(--navy);
      cursor:pointer;
      box-shadow:0 6px 18px rgba(0,0,0,.04);
    }

    .messages{
      max-width:920px;
      margin:14px auto 0;
      padding:0 10px;
      display:flex;
      flex-direction:column;
      gap:10px;
    }
    .msg{
      max-width:85%;
      padding:12px 14px;
      border-radius:16px;
      white-space:pre-wrap;
      line-height:1.35;
    }
    .msg.assistant{ background:#f2f6ff; align-self:flex-start; }
    .msg.user{ background:var(--blue); color:#fff; align-self:flex-end; }

    /* Sections */
    .section{ padding:18px 18px 28px; }
    .section h2{ margin:12px 0 6px; font-size:22px; letter-spacing:-.2px; }
    .section p{ margin:0 0 14px; color:var(--muted); font-weight:600; }

    .grid{ display:grid; grid-template-columns:repeat(3, 1fr); gap:14px; }
    .card{
      border:1px solid var(--line);
      border-radius:18px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      overflow:hidden;
      cursor:pointer;
      box-shadow:0 10px 22px rgba(0,0,0,.05);
      min-height:140px;
    }
    .card .pad{ padding:16px; }
    .kicker{
      display:inline-block;
      font-size:12px;
      font-weight:900;
      color:#fff;
      background:rgba(11,95,255,.92);
      padding:6px 10px;
      border-radius:999px;
      margin-bottom:10px;
    }
    .title{ font-weight:900; font-size:16px; margin-bottom:6px; }
    .desc{ color:var(--muted); font-weight:600; font-size:13px; }

    .list{
      margin-top:14px;
      display:grid;
      grid-template-columns:repeat(2,1fr);
      gap:10px 16px;
      padding:0;
      list-style:none;
    }
    .list li{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:12px 14px;
      font-weight:900;
      color:var(--navy);
    }

    .note{
      margin-top:14px;
      border:1px dashed #c7d6f3;
      background:#f7fbff;
      border-radius:16px;
      padding:14px;
      color:var(--muted);
      font-weight:700;
      font-size:13px;
    }

    /* Mobile */
    @media (max-width: 950px){
      .grid{ grid-template-columns:1fr; }
      .alerts{ grid-template-columns:1fr; }
      .hero h1{ font-size:32px; }
      .chat-row{ flex-direction:column; }
      .chat-row button{ width:100%; }
      .list{ grid-template-columns:1fr; }
      .brand span{ font-size:15px; }
      .brand img{ height:34px; }
      .nav{ gap:8px; }
      .btn{ padding:9px 12px; border-radius:12px; }
    }
  </style>
</head>

<body>
  <div class="wrap">
    <div class="shell">

      <div class="topbar">
        <a class="brand" href="/ai/">
          <img src="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png" alt="WhataShine Logistics">
          <span>WhataShine Logistics</span>
        </a>

        <div class="nav">
          <a class="btn" href="tel:+12145551212">Call Now</a>
          <a class="btn primary" href="/ai/quote.php">Get a Quote</a>
          <a class="btn" href="/ai/portal.php">Client Portal</a>
        </div>
      </div>

      <div class="banner">
        💧 24/7 Emergency Service Available
        <small>Water extraction • drying • mold guidance • moisture monitoring</small>
      </div>

      <div class="hero">
        <h1><?php echo $pageTitle; ?></h1>
        <p>Tell us what happened — we’ll guide you to the right response and next steps.</p>
      </div>

      <div class="alerts">
        <div class="alert" onclick="quick('There is standing water. What should I do first?')">
          <span class="tag danger">Urgent</span>
          <div class="t">Standing water / active leak</div>
          <div class="d">Shutoff, safety steps, and rapid extraction guidance.</div>
        </div>
        <div class="alert" onclick="quick('There is a musty smell or visible mold. What do you recommend?')">
          <span class="tag warn">Mold</span>
          <div class="t">Musty odor / visible growth</div>
          <div class="d">Containment guidance + next steps to reduce spread.</div>
        </div>
        <div class="alert" onclick="quick('We need drying equipment and moisture readings. What info do you need?')">
          <span class="tag ok">Drying</span>
          <div class="t">Dry-out & monitoring</div>
          <div class="d">Dehumidification plan + moisture checks.</div>
        </div>
      </div>

      <!-- Chat -->
      <div class="chat">
        <div class="chat-row">
          <input id="chatInput" placeholder="Type your question here…" />
          <button onclick="sendMessage()">Send</button>
        </div>

        <div class="chips">
          <button class="chip" onclick="quick('I have a water leak and need emergency help')">Emergency water help</button>
          <button class="chip" onclick="quick('Do you handle mold issues and remediation?')">Mold issues</button>
          <button class="chip" onclick="quick('What is your response time and service area?')">Response time</button>
          <button class="chip" onclick="quick('I need a quote—what info do you need from me?')">Get a quote</button>
        </div>
      </div>

      <div class="messages" id="messages">
        <div class="msg assistant">
Hi — I can help. Quick questions:
1) What city is the property in?
2) What happened (leak, overflow, storm, HVAC, roof)?
3) How long has it been wet (hours/days)?
        </div>
      </div>

      <!-- Services -->
      <div class="section">
        <h2>Water restoration services</h2>
        <p>Tap a service to ask about it or start a quote request.</p>

        <div class="grid">
          <div class="card" onclick="quick('We need emergency water extraction. What info do you need to dispatch?')">
            <div class="pad">
              <div class="kicker">Emergency</div>
              <div class="title">Water Extraction / Removal</div>
              <div class="desc">Rapid response • pump-out • wet vac • mitigation</div>
            </div>
          </div>

          <div class="card" onclick="quick('We need drying and dehumidification. What’s your typical process?')">
            <div class="pad">
              <div class="kicker">Drying</div>
              <div class="title">Drying & Dehumidification</div>
              <div class="desc">Air movers • dehus • containment drying strategy</div>
            </div>
          </div>

          <div class="card" onclick="quick('We need moisture checks and documentation. How do you track readings?')">
            <div class="pad">
              <div class="kicker">Monitoring</div>
              <div class="title">Moisture Monitoring</div>
              <div class="desc">Moisture mapping • daily readings • progress tracking</div>
            </div>
          </div>
        </div>

        <h2 style="margin-top:22px;">Mold services</h2>
        <p>We’ll help you identify risk and route to the right next steps.</p>

        <div class="grid">
          <div class="card" onclick="quick('We have visible mold. What should we do immediately to reduce spread?')">
            <div class="pad">
              <div class="kicker">Mold</div>
              <div class="title">Mold Assessment & Guidance</div>
              <div class="desc">Containment guidance • safety • next steps</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you handle remediation and removal? What scope info do you need?')">
            <div class="pad">
              <div class="kicker">Remediation</div>
              <div class="title">Mold Remediation Support</div>
              <div class="desc">Source control • removal plan • cleaning protocol</div>
            </div>
          </div>

          <div class="card" onclick="quick('Can you help find the moisture source that caused the mold?')">
            <div class="pad">
              <div class="kicker">Root Cause</div>
              <div class="title">Moisture Source Investigation</div>
              <div class="desc">Leak indicators • humidity issues • recurring wet areas</div>
            </div>
          </div>
        </div>

        <h2 style="margin-top:22px;">What we typically cover</h2>
        <p>Common scope items on water/mold calls.</p>

        <ul class="list">
          <li>Emergency water extraction</li>
          <li>Dry-out planning</li>
          <li>Dehumidifier / air mover setup</li>
          <li>Moisture readings & documentation</li>
          <li>Containment guidance</li>
          <li>Surface cleaning support</li>
          <li>Odor control</li>
          <li>Leak source coordination</li>
          <li>Wet materials evaluation</li>
          <li>Post-dry verification</li>
        </ul>

        <div class="note">
          Tip: For the fastest quote, include: city, building type (hotel/office), affected areas (rooms, hallway, lobby),
          approximate sqft, and how long it has been wet.
        </div>
      </div>

    </div>
  </div>

<script>
function addMessage(text, cls){
  const m = document.createElement("div");
  m.className = "msg " + cls;
  m.textContent = text;
  document.getElementById("messages").appendChild(m);
  return m;
}
function quick(text){
  const input = document.getElementById("chatInput");
  input.value = text;
  sendMessage();
}
async function sendMessage(){
  const input = document.getElementById("chatInput");
  const text = input.value.trim();
  if(!text) return;

  addMessage(text, "user");
  input.value = "";

  const bubble = addMessage("Thinking…", "assistant");

  try {
    const res = await fetch("/ai/api/chat.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ message: text }),
      cache: "no-store"
    });

    const raw = await res.text();

    if (!res.ok) {
      bubble.textContent = "Server error (" + res.status + "):\n" + raw.slice(0, 200);
      return;
    }

    let reply = "";
    try {
      const data = JSON.parse(raw);
      reply = data.reply || "";
    } catch (e) {
      reply = raw;
    }

    bubble.textContent = reply ? reply.replace(/\\n/g, "\n") : "No reply received.";
  } catch (err) {
    bubble.textContent = "Request failed: " + (err?.message || "Unknown error");
  }
}

document.addEventListener("DOMContentLoaded", () => {
  const input = document.getElementById("chatInput");
  if (input) {
    input.addEventListener("keydown", (e) => {
      if (e.key === "Enter") sendMessage();
    });
  }
});
</script>

</body>
</html>
