const input = document.getElementById("chatInput");
const sendBtn = document.getElementById("sendBtn");

function setAndSend(text){
  input.value = text;
  input.focus();
  // for now, mimic submit without backend
  // later: replace with fetch to /ai/api/chat.php
  console.log("Prompt:", text);
}

sendBtn.addEventListener("click", () => {
  const text = (input.value || "").trim();
  if(!text) return;
  setAndSend(text);
});

input.addEventListener("keydown", (e) => {
  if(e.key === "Enter"){
    e.preventDefault();
    sendBtn.click();
  }
});

// Chips
document.querySelectorAll(".chip").forEach(btn => {
  btn.addEventListener("click", () => setAndSend(btn.dataset.q || btn.textContent));
});

// Tiles
document.querySelectorAll(".tile").forEach(tile => {
  tile.addEventListener("click", () => setAndSend(tile.dataset.q || "Tell me more."));
});
