<?php
// /public_html/ai/index.php

// Quick site settings
$siteName = "WhataShine Logistics";
$tagline   = "24/7 Emergency Service Available";

// Top nav links
$phoneHref = "tel:+12145551212";
$getQuoteHref = "#";        // change later
$portalHref   = "#";        // change later
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="icon" href="/ai/assets/images/favicon.ico" sizes="any">
  <link rel="icon" type="image/png" sizes="32x32" href="/ai/assets/images/favicon.png">
  <link rel="apple-touch-icon" href="/ai/assets/images/favicon.png">
  <title><?php echo htmlspecialchars($siteName); ?> | AI Service Assistant</title>

  <style>
    :root{
      --bg1:#dbe8f5;
      --bg2:#f4f8ff;
      --card:#ffffff;
      --text:#0b2b5b;
      --muted:#5a6b86;
      --line:#e6edf7;
      --blue:#0b5fff;
      --blue2:#0a4fd6;
      --shadow: 0 14px 40px rgba(0,0,0,.10);
      --shadow2: 0 10px 26px rgba(0,0,0,.08);
      --radius: 18px;
    }
    *{box-sizing:border-box}
    body{
      margin:0;
      font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Arial,sans-serif;
      color:var(--text);
      background: radial-gradient(1100px 520px at 50% -10%, #ffffff 0%, rgba(255,255,255,.65) 35%, rgba(255,255,255,0) 60%),
                  linear-gradient(180deg,var(--bg1),var(--bg2));
      min-height:100vh;
    }
    .shell{
      max-width: 1180px;
      margin: 18px auto 44px;
      padding: 0 14px;
    }
    .panel{
      background: rgba(255,255,255,.72);
      border: 1px solid rgba(255,255,255,.55);
      border-radius: 22px;
      box-shadow: var(--shadow);
      overflow: hidden;
      backdrop-filter: blur(10px);
    }

    /* Top bar */
    .topbar{
      display:flex;
      align-items:center;
      justify-content:space-between;
      padding: 14px 18px;
      background: linear-gradient(180deg, rgba(255,255,255,.85), rgba(255,255,255,.55));
      border-bottom: 1px solid rgba(230,237,247,.9);
    }
    /* BRAND / LOGO */
    .brand {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .drop{
      width:28px;height:28px;border-radius:10px;
      background: radial-gradient(circle at 35% 25%, #62d1ff, #0b5fff 58%, #083aa8 100%);
      box-shadow: 0 8px 18px rgba(11,95,255,.35);
      position: relative;
    }
    .drop:after{
      content:"";
      position:absolute; inset:7px 9px 10px 9px;
      border-radius: 50% 50% 50% 50%;
      background: rgba(255,255,255,.35);
      transform: rotate(-18deg);
      filter: blur(.2px);
    }
    .nav{
      display:flex; align-items:center; gap:10px; flex-wrap:wrap;
    }
    .nav a{
      text-decoration:none;
      font-weight: 800;
      color: var(--text);
      padding: 10px 14px;
      border-radius: 12px;
      border: 1px solid var(--line);
      background: rgba(255,255,255,.8);
    }
    .nav a.primary{
      border-color: transparent;
      background: linear-gradient(180deg,var(--blue),var(--blue2));
      color:#fff;
      box-shadow: 0 10px 22px rgba(11,95,255,.25);
    }

    /* Tiny banner row */
    .mini{
      text-align:center;
      padding: 10px 14px;
      font-weight: 800;
      color: #2c558f;
      background: linear-gradient(180deg, rgba(240,247,255,.8), rgba(240,247,255,.25));
      border-bottom: 1px solid rgba(230,237,247,.9);
    }

    /* Main hero */
    .hero{
      padding: 34px 18px 18px;
      text-align:center;
    }
    .hero h1{
      margin: 12px 0 10px;
      font-size: 54px;
      line-height: 1.06;
      letter-spacing: -0.6px;
    }
    .hero p{
      margin: 0 0 18px;
      color: var(--muted);
      font-weight: 650;
    }

    /* Chat input row */
    .chatRow{
      max-width: 820px;
      margin: 18px auto 10px;
      display:flex;
      gap: 10px;
      align-items: center;
      justify-content:center;
      padding: 0 10px;
    }
    .chatRow input{
      flex: 1;
      min-width: 220px;
      padding: 16px 16px;
      border-radius: 14px;
      border: 1px solid rgba(0,0,0,.08);
      background: rgba(255,255,255,.85);
      font-size: 16px;
      outline:none;
      box-shadow: 0 10px 20px rgba(0,0,0,.06);
    }
    .chatRow button{
      padding: 16px 18px;
      border-radius: 14px;
      border: none;
      cursor:pointer;
      font-weight: 900;
      font-size: 16px;
      color:#fff;
      background: linear-gradient(180deg,var(--blue),var(--blue2));
      box-shadow: 0 12px 24px rgba(11,95,255,.28);
      min-width: 120px;
    }
    .chatRow button:active{transform: translateY(1px)}

    /* Quick chips */
    .chips{
      max-width: 820px;
      margin: 10px auto 0;
      display:flex;
      gap:10px;
      justify-content:center;
      flex-wrap:wrap;
      padding: 0 10px 8px;
    }
    .chip{
      border: 1px solid rgba(0,0,0,.08);
      background: rgba(255,255,255,.8);
      padding: 10px 12px;
      border-radius: 12px;
      font-weight: 800;
      color: #244a7b;
      cursor:pointer;
      box-shadow: 0 8px 16px rgba(0,0,0,.05);
      user-select:none;
    }

    /* Service cards grid */
    .grid{
      padding: 18px;
      display:grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 16px;
    }
    .card{
      border-radius: 18px;
      overflow:hidden;
      background: #0b2b5b;
      box-shadow: var(--shadow2);
      border: 1px solid rgba(255,255,255,.10);
      min-height: 150px;
      position: relative;
      cursor:pointer;
      transform: translateZ(0);
    }
    .card::before{
      content:"";
      position:absolute; inset:0;
      background:
        radial-gradient(900px 260px at 20% 10%, rgba(98,209,255,.45), rgba(11,95,255,.10) 55%, rgba(0,0,0,0) 70%),
        linear-gradient(180deg, rgba(255,255,255,.10), rgba(0,0,0,.30));
      pointer-events:none;
    }
    .card .content{
      position:absolute; inset:0;
      padding: 18px;
      display:flex;
      flex-direction:column;
      justify-content:flex-end;
      gap:6px;
      color:#fff;
    }
    .card .title{
      font-weight: 950;
      font-size: 20px;
      letter-spacing: -0.2px;
      text-shadow: 0 10px 18px rgba(0,0,0,.30);
    }
    .card .desc{
      font-weight: 700;
      font-size: 13px;
      opacity: .88;
    }
    .badge{
      position:absolute;
      top:14px; left:14px;
      background: rgba(255,255,255,.18);
      border: 1px solid rgba(255,255,255,.22);
      padding: 8px 10px;
      border-radius: 14px;
      font-weight: 900;
      color:#fff;
      font-size: 12px;
      backdrop-filter: blur(6px);
    }

    /* Footer spacer */
    .footSpace{height: 16px}

    /* Responsive */
    @media (max-width: 1050px){
      .grid{ grid-template-columns: repeat(2, 1fr); }
      .hero h1{ font-size: 44px; }
    }
    @media (max-width: 640px){
      .hero{ padding-top: 26px; }
      .hero h1{ font-size: 36px; }
      .grid{ grid-template-columns: 1fr; }
      .chatRow button{ min-width: 96px; }
    }
    /* --- Service Cards Grid --- */
    .cards {
      margin-top: 26px;
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 18px;
    }

    @media (max-width: 1100px) {
      .cards { grid-template-columns: repeat(2, 1fr); }
    }
    @media (max-width: 650px) {
      .cards { grid-template-columns: 1fr; }
    }

    .card {
      position: relative;
      height: 220px;
      border-radius: 18px;
      overflow: hidden;
      cursor: pointer;
      border: 1px solid rgba(9, 56, 140, 0.25);
      background: #0b2b5b; /* fallback */
      background-size: cover;
      background-position: center;
      box-shadow: 0 12px 30px rgba(0,0,0,0.08);
      transition: transform .15s ease, box-shadow .15s ease;
    }

    .card:hover {
      transform: translateY(-2px);
      box-shadow: 0 18px 40px rgba(0,0,0,0.14);
    }

    /* dark overlay so text pops */
    .card::before {
      content: "";
      position: absolute;
      inset: 0;
      background: linear-gradient(
        180deg,
        rgba(0,0,0,0.05) 0%,
        rgba(0,0,0,0.35) 45%,
        rgba(0,0,0,0.70) 100%
      );
    }

    .card .badge {
      position: absolute;
      top: 14px;
      left: 14px;
      z-index: 2;
      font-weight: 800;
      font-size: 12px;
      padding: 8px 10px;
      border-radius: 999px;
      color: #0b2b5b;
      background: rgba(255,255,255,0.92);
      border: 1px solid rgba(0,0,0,0.08);
    }

    .card .content {
      position: absolute;
      left: 16px;
      right: 16px;
      bottom: 16px;
      z-index: 2;
      color: #fff;
      text-shadow: 0 2px 8px rgba(0,0,0,0.35);
    }

    .card .title {
      font-size: 18px;
      font-weight: 900;
      line-height: 1.15;
      margin-bottom: 6px;
    }

    .card .desc {
      font-size: 13px;
      font-weight: 600;
      opacity: 0.92;
    }

    /* Chat area styles */
    .chat-area {
      max-width: 900px;
      margin: 30px auto;
    }

    .chat-messages {
      display: flex;
      flex-direction: column;
      gap: 10px;
      padding: 16px;
      border-radius: 16px;
      background: #f7faff;
      max-height: 280px;
      overflow-y: auto;
    }

    .msg {
      padding: 12px 14px;
      border-radius: 14px;
      max-width: 75%;
      white-space: pre-wrap;
    }

    .msg.assistant {
      background: #eef3ff;
      align-self: flex-start;
    }

    .msg.user {
      background: #0b5fff;
      color: #fff;
      align-self: flex-end;
    }

    .chat-input-row {
      display: flex;
      gap: 10px;
      margin-top: 12px;
    }

    .chat-input-row input {
      flex: 1;
      padding: 14px;
      border-radius: 14px;
      border: 1px solid #d9e5f7;
    }

    .chat-input-row button {
      padding: 14px 20px;
      border-radius: 14px;
      border: none;
      background: #0b5fff;
      line-height: 1;
      color: #fff;
      font-weight: 700;
      cursor: pointer;
    }

    /* ===== Mobile Fix Pack ===== */
    * { box-sizing: border-box; }
    html, body { width: 100%; overflow-x: hidden; }

    /* Make main wrapper breathe on small screens */
    @media (max-width: 900px) {
      .container {
        width: calc(100% - 24px);
        margin: 12px auto;
        padding: 14px;
        border-radius: 16px;
      }

      /* Top bar */
      .topbar {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
      }

      .nav {
        width: 100%;
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
      }
      .nav a {
        margin-left: 0;
        flex: 1 1 auto;
        text-align: center;
        padding: 10px 12px;
      }

      /* Banner */
      .banner {
        margin-top: 10px;
        font-size: 13px;
        padding: 10px 12px;
      }

      /* Headline */
      h1 {
        font-size: clamp(24px, 6vw, 34px);
        margin-top: 18px;
        line-height: 1.15;
      }

      .sub {
        font-size: 14px;
        margin-top: 8px;
        padding: 0 6px;
      }

      /* Chat area */
      .chat-area,
      .chat-box {
        max-width: 100%;
        margin: 18px auto 0;
      }

      /* Messages */
      .chat-messages,
      .messages {
        max-height: 220px;
        padding: 12px;
        border-radius: 16px;
      }

      /* Input row: keep it like the mockup */
      .chat-input-row,
      .input-row {
        display: grid;
        grid-template-columns: 1fr auto;
        gap: 10px;
        align-items: center;
      }

      .chat-input-row input,
      .input-row input,
      #chatInput {
        width: 100%;
        min-width: 0;
        padding: 14px 14px;
        border-radius: 14px;
        font-size: 16px; /* prevents iOS zoom */
      }

      .chat-input-row button,
      .input-row button {
        width: 110px;              /* like reference */
        padding: 14px 16px;
        border-radius: 14px;
        white-space: nowrap;
      }

      /* Quick buttons (chips) */
      .quick-row, .quick-buttons, .chips {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        justify-content: center;
        margin-top: 12px;
      }
      .quick-row button,
      .quick-buttons button,
      .chips button {
        flex: 1 1 calc(50% - 10px);
        max-width: 420px;
        padding: 10px 12px;
        border-radius: 12px;
      }

      /* Cards/Boxes grid */
      .cards,
      .tiles,
      .card-grid {
        display: grid;
        grid-template-columns: 1fr 1fr; /* 2-up on most phones */
        gap: 14px;
        margin-top: 18px;
      }
    }

    /* Very small phones: 1 column for cards */
    @media (max-width: 520px) {
      .cards,
      .tiles,
      .card-grid {
        grid-template-columns: 1fr;
      }

      .chat-input-row,
      .input-row {
        grid-template-columns: 1fr;
      }

      .chat-input-row button,
      .input-row button {
        width: 100%;
      }

      .quick-row button,
      .quick-buttons button,
      .chips button {
        flex: 1 1 100%;
      }
    }

    /* Card image behavior (if you're using background images) */
    .card {
      overflow: hidden;
      border-radius: 18px;
    }

    .card .bg,
    .card img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      display: block;
    }

    .site-logo {
      height: 44px;
      width: auto;
    }

    .brand-name {
      font-size: 18px;
      font-weight: 800;
      color: #0b2b5b;
      white-space: nowrap;
    }

    /* Mobile tuning */
    @media (max-width: 768px) {
      .site-logo {
        height: 34px;
      }

      .brand-name {
        font-size: 15px;
      }
    }

    /* Header / brand layout overrides */
    .topbar{
      display:flex;
      justify-content:space-between;
      align-items:center;
      gap:12px;
    }

    .brand{
      display:flex;
      align-items:center;
      gap:10px;
      text-decoration:none;
      min-width: 220px;
    }

    .site-logo{
      height:44px;
      width:auto;
      display:block;
    }

    .brand-name{
      display:inline-block !important;
      font-size:18px;
      font-weight:800;
      color:#0b2b5b;
      line-height:1;
      white-space:nowrap;
    }

    /* Mobile */
    @media (max-width:768px){
      .brand{min-width:0;}
      .site-logo{height:34px;}
      .brand-name{font-size:15px;}
    }

  </style>
</head>

<body>
  <div class="shell">
    <div class="panel">

      <div class="topbar">
        <a class="brand" href="/ai/">
          <img src="/ai/assets/images/logo.png" class="site-logo" alt="WhataShine Logistics">
          <span class="brand-name"><?php echo htmlspecialchars($siteName); ?></span>
        </a>
        <div class="nav">
          <a href="<?php echo htmlspecialchars($phoneHref); ?>">Call Now</a>
          <a class="primary" href="<?php echo htmlspecialchars($getQuoteHref); ?>">Get a Quote</a>
          <a href="<?php echo htmlspecialchars($portalHref); ?>">Client Portal</a>
        </div>
      </div>

      <div class="mini">💧 <?php echo htmlspecialchars($tagline); ?></div>

      <div class="hero">
        <h1>How can I help you today?</h1>
        <p>Tell us what you need — we’ll guide you to the right service.</p>

        <div class="chat-area">
          <div id="chatMessages" class="chat-messages">
            <div class="msg assistant">
              Hi! What service are you looking for today?
            </div>
          </div>

          <div class="chat-input-row">
            <input
              id="chatInput"
              type="text"
              placeholder="Type your question here…"
              autocomplete="off"
            />
            <button onclick="sendMessage()">Send</button>
          </div>
        </div>

        <div class="chips">
          <div class="chip" data-fill="I need help with cleaning">I need help with cleaning</div>
          <div class="chip" data-fill="Do you handle floor restoration?">Do you handle floor restoration?</div>
          <div class="chip" data-fill="Do you handle mold issues?">Do you handle mold issues?</div>
          <div class="chip" data-fill="What’s your response time?">What’s your response time?</div>
        </div>
      </div>

      <!-- 4 service boxes (your categories) -->
      <div class="cards">

  <div class="card"
       style="background-image:url('/ai/assets/images/commercialphoto.png')"
       onclick="quick('I need commercial & hospitality cleaning (daily/turnover/deep cleaning).')">
    <div class="badge">Cleaning</div>
    <div class="content">
      <div class="title">Commercial & Hospitality Cleaning</div>
      <div class="desc">Daily • Turnover • Deep Cleaning</div>
    </div>
  </div>

  <div class="card"
       style="background-image:url('/ai/assets/images/watermoldprofilephoto.png')"
       onclick="quick('I need water restoration or mold help (dry-out, mold, emergency).')">
    <div class="badge">Water & Mold</div>
    <div class="content">
      <div class="title">Water & Mold Restoration</div>
      <div class="desc">Dry-Out • Mold • Emergency Response</div>
    </div>
  </div>

  <div class="card"
       style="background-image:url('/ai/assets/images/floorcareprofilephoto.png')"
       onclick="quick('I need floor and surface restoration (stone/marble/polishing).')">
    <div class="badge">Floor Care</div>
    <div class="content">
      <div class="title">Floor & Surface Restoration</div>
      <div class="desc">Stone • Marble • Polishing</div>
    </div>
  </div>

  <div class="card"
       style="background-image:url('/ai/assets/images/engineeringprofilephoto.png')"
       onclick="quick('I need engineering/equipment help (repairs, coordination, support).')">
    <div class="badge">Engineering</div>
    <div class="content">
      <div class="title">Engineering & Equipment</div>
      <div class="desc">Coordination • Repairs • Support</div>
    </div>
  </div>

</div>


  <script>
    // This is FRONT-END ONLY for now (no AI call).
    // It fills the input and shows a simple "assistant" response so the UI feels alive.
    const input = document.getElementById("chatInput");

    function setInput(text){
      if(!input) return;
      input.value = text;
      input.focus();
    }

    // Chips fill input
    document.querySelectorAll(".chip").forEach(chip => {
      chip.addEventListener("click", () => setInput(chip.getAttribute("data-fill") || ""));
    });

    // Cards fill input (only when data-fill exists)
    document.querySelectorAll(".card").forEach(card => {
      const df = card.getAttribute("data-fill");
      if (df) card.addEventListener("click", () => setInput(df));
    });

    // Helper used by the inline onclick handlers in the cards
    function quick(text){
      setInput(text || "");
    }

    function fakeReply(userText){
      // quick placeholder reply (we will swap this to your /ai/api/chat.php later)
      const t = (userText || "").toLowerCase();
      if (t.includes("mold") || t.includes("water")) return "Got it. Is this an active emergency (water still coming in), and what city are you in?";
      if (t.includes("floor") || t.includes("marble") || t.includes("counter")) return "Perfect. What type of surface (marble, stone, tile) and roughly how many sqft?";
      if (t.includes("equipment") || t.includes("engineer")) return "Understood. What equipment or issue are we dealing with and which property/city?";
      return "Thanks — what city is the property in and what service frequency do you need (one-time, nightly, weekly)?";
    }

    async function sendMessage(){
      const text = (input.value || "").trim();
      if(!text) return;

      // For now, just show a browser alert so you can confirm the UI works.
      // Replace this with your AI call later.
      alert("You: " + text + "\n\nAssistant: " + fakeReply(text));
      input.value = "";
      input.focus();
    }

    if(input){
      input.addEventListener("keydown", (e) => {
        if(e.key === "Enter") sendMessage();
      });
    }
  </script>
  <script>
  function addMessage(text, role) {
    const messages = document.getElementById("chatMessages");
    const msg = document.createElement("div");
    msg.className = "msg " + role;
    msg.textContent = text;
    messages.appendChild(msg);
    messages.scrollTop = messages.scrollHeight;
    return msg;
  }

  async function sendMessage() {
    const input = document.getElementById("chatInput");
    const text = input.value.trim();
    if (!text) return;

    addMessage(text, "user");
    input.value = "";

    const thinking = addMessage("Thinking…", "assistant");

    try {
      const res = await fetch("/ai/api/chat.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ message: text })
      });

      const raw = await res.text();

      if (!res.ok) {
        thinking.textContent = "Server error. Please try again.";
        return;
      }

      let data;
      try {
        data = JSON.parse(raw);
      } catch {
        thinking.textContent = "Invalid response from server.";
        return;
      }

      thinking.textContent = data.reply || "No response.";
    } catch (err) {
      thinking.textContent = "Connection failed.";
    }
  }

  // Send on Enter
  document.addEventListener("DOMContentLoaded", () => {
    const input = document.getElementById("chatInput");
    input.addEventListener("keydown", e => {
      if (e.key === "Enter") sendMessage();
    });
  });
  </script>
</body>
</html>




