<?php
// /ai/hospitality.php
$siteName = "WhataShine Logistics";
$pageTitle = "Commercial & Hospitality Cleaning";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?php echo $siteName; ?> | <?php echo $pageTitle; ?></title>

  <!-- Favicon (update filename to your real one) -->
  <link rel="icon" type="image/png" href="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png">

  <style>
    :root{
      --blue:#0b5fff;
      --navy:#0b2b5b;
      --bg:#f3f6fb;
      --card:#ffffff;
      --muted:#4a5b77;
      --line:#e6edf7;
      --soft:#eef4ff;
      --shadow: 0 10px 30px rgba(0,0,0,.07);
      --radius: 16px;
    }

    *{ box-sizing:border-box; }
    body{
      margin:0;
      font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Arial,sans-serif;
      background:var(--bg);
      color:var(--navy);
    }

    .wrap{
      max-width:1100px;
      margin:18px auto 40px;
      padding:0 14px;
    }

    .shell{
      background:var(--card);
      border-radius:18px;
      box-shadow:var(--shadow);
      overflow:hidden;
      border:1px solid var(--line);
    }

    /* Top Bar */
    .topbar{
      display:flex;
      justify-content:space-between;
      align-items:center;
      padding:14px 16px;
      gap:12px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      border-bottom:1px solid var(--line);
    }
    .brand{
      display:flex;
      align-items:center;
      gap:10px;
      text-decoration:none;
      min-width:220px;
    }
    .brand img{
      height:42px;
      width:auto;
      display:block;
    }
    .brand span{
      font-weight:900;
      color:var(--navy);
      font-size:18px;
      white-space:nowrap;
    }
    .nav{
      display:flex;
      gap:10px;
      align-items:center;
    }
    .btn{
      border:1px solid var(--line);
      background:#fff;
      padding:10px 14px;
      border-radius:14px;
      text-decoration:none;
      font-weight:800;
      color:var(--navy);
      display:inline-flex;
      align-items:center;
      gap:8px;
    }
    .btn.primary{
      background:var(--blue);
      color:#fff;
      border-color:transparent;
    }

    .banner{
      text-align:center;
      padding:10px 14px;
      background:var(--soft);
      font-weight:800;
      color:var(--navy);
      border-bottom:1px solid var(--line);
    }

    /* Hero + Chat */
    .hero{
      padding:22px 18px 8px;
      text-align:center;
    }
    .hero h1{
      margin:10px 0 6px;
      font-size:40px;
      letter-spacing:-.5px;
    }
    .hero p{
      margin:0;
      color:var(--muted);
      font-weight:600;
    }

    .chat{
      max-width:860px;
      margin:16px auto 6px;
      padding:0 10px;
    }

    .chat-row{
      display:flex;
      gap:10px;
      align-items:stretch;
    }

    .chat-row input{
      flex:1;
      border:1px solid var(--line);
      border-radius:16px;
      padding:16px;
      font-size:16px;
      outline:none;
    }

    .chat-row button{
      min-width:120px;
      border:0;
      border-radius:16px;
      background:var(--blue);
      color:#fff;
      font-weight:900;
      cursor:pointer;
      padding:16px 18px;
    }

    .chips{
      display:flex;
      gap:10px;
      flex-wrap:wrap;
      justify-content:center;
      padding:12px 0 0;
    }
    .chip{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:10px 14px;
      font-weight:800;
      color:var(--navy);
      cursor:pointer;
      box-shadow:0 6px 18px rgba(0,0,0,.04);
    }

    .messages{
      max-width:860px;
      margin:14px auto 0;
      padding:0 10px;
      display:flex;
      flex-direction:column;
      gap:10px;
    }
    .msg{
      max-width:85%;
      padding:12px 14px;
      border-radius:16px;
      white-space:pre-wrap;
      line-height:1.35;
    }
    .msg.assistant{
      background:#f2f6ff;
      align-self:flex-start;
    }
    .msg.user{
      background:var(--blue);
      color:#fff;
      align-self:flex-end;
    }

    /* Sections */
    .section{
      padding:18px 18px 26px;
    }
    .section h2{
      margin:12px 0 6px;
      font-size:22px;
      letter-spacing:-.2px;
    }
    .section p{
      margin:0 0 14px;
      color:var(--muted);
      font-weight:600;
    }

    .grid{
      display:grid;
      grid-template-columns:repeat(3, 1fr);
      gap:14px;
    }
    .card{
      border:1px solid var(--line);
      border-radius:18px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      overflow:hidden;
      cursor:pointer;
      box-shadow:0 10px 22px rgba(0,0,0,.05);
      position:relative;
      min-height:140px;
    }
    .card .pad{
      padding:16px;
    }
    .kicker{
      display:inline-block;
      font-size:12px;
      font-weight:900;
      color:#fff;
      background:rgba(11,95,255,.92);
      padding:6px 10px;
      border-radius:999px;
      margin-bottom:10px;
    }
    .title{
      font-weight:900;
      font-size:16px;
      margin-bottom:6px;
    }
    .desc{
      color:var(--muted);
      font-weight:600;
      font-size:13px;
    }

    .list{
      margin-top:14px;
      display:grid;
      grid-template-columns:repeat(2,1fr);
      gap:10px 16px;
      padding:0;
      list-style:none;
    }
    .list li{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:12px 14px;
      font-weight:800;
      color:var(--navy);
    }

    /* Mobile */
    @media (max-width: 950px){
      .grid{ grid-template-columns:1fr; }
      .hero h1{ font-size:32px; }
      .chat-row{ flex-direction:column; }
      .chat-row button{ width:100%; }
      .list{ grid-template-columns:1fr; }
      .brand span{ font-size:15px; }
      .brand img{ height:34px; }
      .nav{ gap:8px; }
      .btn{ padding:9px 12px; border-radius:12px; }
    }
  </style>
</head>

<body>
  <div class="wrap">
    <div class="shell">

      <div class="topbar">
        <a class="brand" href="/ai/">
          <img src="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png" alt="WhataShine Logistics">
          <span>WhataShine Logistics</span>
        </a>

        <div class="nav">
          <a class="btn" href="tel:+12145551212">Call Now</a>
          <a class="btn primary" href="/ai/quote.php">Get a Quote</a>
          <a class="btn" href="/ai/portal.php">Client Portal</a>
        </div>
      </div>

      <div class="banner">Commercial & Hospitality Cleaning • 24/7 Support Available</div>

      <div class="hero">
        <h1><?php echo $pageTitle; ?></h1>
        <p>Tell us what your property needs — the assistant will guide you to the right service.</p>
      </div>

      <!-- Chat -->
      <div class="chat">
        <div class="chat-row">
          <input id="chatInput" placeholder="Type your question here…" />
          <button onclick="sendMessage()">Send</button>
        </div>

        <div class="chips">
          <button class="chip" onclick="quick('I need nightly/recurring hotel cleaning')">Recurring hotel cleaning</button>
          <button class="chip" onclick="quick('I need a deep clean for rooms and common areas')">Deep clean</button>
          <button class="chip" onclick="quick('Do you handle carpet and upholstery cleaning?')">Carpet & upholstery</button>
          <button class="chip" onclick="quick('What’s your response time and how soon can you start?')">Response time</button>
        </div>
      </div>

      <div class="messages" id="messages">
        <div class="msg assistant">
Hi! What type of hospitality cleaning can we help you with today?
(Hotel, extended-stay, office, restaurant, event space — and what city?)
        </div>
      </div>

      <!-- Services -->
      <div class="section">
        <h2>Services we can handle</h2>
        <p>Tap a service to ask the assistant about it or request a quote.</p>

        <div class="grid">
          <div class="card" onclick="quick('I need recurring cleaning for a hotel. How does onboarding work?')">
            <div class="pad">
              <div class="kicker">Hospitality</div>
              <div class="title">Recurring Hotel & Turnover Cleaning</div>
              <div class="desc">Nightly • Weekly • Turnover • Staffing support</div>
            </div>
          </div>

          <div class="card" onclick="quick('I need a deep clean. What areas do you cover and what info do you need?')">
            <div class="pad">
              <div class="kicker">Deep Clean</div>
              <div class="title">Deep Cleaning (Rooms + Common Areas)</div>
              <div class="desc">Baseboards • bathrooms • kitchens • detailed reset</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you handle carpet extraction and upholstery cleaning?')">
            <div class="pad">
              <div class="kicker">Soft Surfaces</div>
              <div class="title">Carpet Extraction & Upholstery</div>
              <div class="desc">Spot treatment • odor control • lobby seating</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you do tile and grout cleaning inside rooms and bathrooms?')">
            <div class="pad">
              <div class="kicker">Hard Surfaces</div>
              <div class="title">Tile & Grout Cleaning (Rooms/Baths)</div>
              <div class="desc">Detail scrub • grout refresh • high-traffic areas</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you offer post-construction or move-out cleaning?')">
            <div class="pad">
              <div class="kicker">Specialty</div>
              <div class="title">Move-Out / Post-Construction Cleaning</div>
              <div class="desc">Dust control • detail wipe-down • final touch</div>
            </div>
          </div>

          <div class="card" onclick="quick('Can you help with lobby/common area cleaning and porter services?')">
            <div class="pad">
              <div class="kicker">Common Areas</div>
              <div class="title">Lobby, Hallways & Porter Services</div>
              <div class="desc">High-visibility cleaning • restrooms • touch-points</div>
            </div>
          </div>
        </div>

        <h2 style="margin-top:22px;">Amenities / areas we commonly clean</h2>
        <p>Here’s the usual scope — we’ll tailor it to your property.</p>

        <ul class="list">
          <li>Guest rooms & suites</li>
          <li>Bathrooms & fixtures</li>
          <li>Hallways & elevators</li>
          <li>Lobby & front desk</li>
          <li>Fitness center</li>
          <li>Meeting rooms</li>
          <li>Break rooms / kitchens</li>
          <li>Back-of-house areas</li>
          <li>Trash removal & restock</li>
          <li>Touchpoint disinfection</li>
        </ul>
      </div>

    </div>
  </div>

<script>
function addMessage(text, cls){
  const m = document.createElement("div");
  m.className = "msg " + cls;
  m.textContent = text;
  document.getElementById("messages").appendChild(m);
  return m;
}

function quick(text){
  const input = document.getElementById("chatInput");
  input.value = text;
  sendMessage();
}

async function sendMessage(){
  const input = document.getElementById("chatInput");
  const text = input.value.trim();
  if(!text) return;

  addMessage(text, "user");
  input.value = "";

  const bubble = addMessage("Thinking…", "assistant");

  try {
    const res = await fetch("/ai/api/chat.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ message: text }),
      cache: "no-store"
    });

    const raw = await res.text();

    if (!res.ok) {
      bubble.textContent = "Server error (" + res.status + "):\n" + raw.slice(0, 200);
      return;
    }

    let reply = "";
    try {
      const data = JSON.parse(raw);
      reply = data.reply || "";
    } catch (e) {
      reply = raw;
    }

    bubble.textContent = reply ? reply.replace(/\\n/g, "\n") : "No reply received.";
  } catch (err) {
    bubble.textContent = "Request failed: " + (err?.message || "Unknown error");
  }
}

document.addEventListener("DOMContentLoaded", () => {
  const input = document.getElementById("chatInput");
  if (input) {
    input.addEventListener("keydown", (e) => {
      if (e.key === "Enter") sendMessage();
    });
  }
});
</script>

</body>
</html>
