<?php
// /ai/floor-surface.php
$siteName  = "WhataShine Logistics";
$pageTitle = "Floor & Surface Restoration";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?php echo $siteName; ?> | <?php echo $pageTitle; ?></title>

  <!-- Favicon (update if your filename differs) -->
  <link rel="icon" type="image/png" href="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png">

  <style>
    :root{
      --blue:#0b5fff;
      --navy:#0b2b5b;
      --bg:#f3f6fb;
      --card:#ffffff;
      --muted:#4a5b77;
      --line:#e6edf7;
      --soft:#eef4ff;
      --shadow: 0 10px 30px rgba(0,0,0,.07);
      --radius: 16px;
      --ok:#16a34a;
      --warn:#f59e0b;
    }
    *{ box-sizing:border-box; }
    body{
      margin:0;
      font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Arial,sans-serif;
      background:var(--bg);
      color:var(--navy);
    }
    .wrap{ max-width:1100px; margin:18px auto 40px; padding:0 14px; }
    .shell{
      background:var(--card);
      border-radius:18px;
      box-shadow:var(--shadow);
      overflow:hidden;
      border:1px solid var(--line);
    }

    /* Topbar */
    .topbar{
      display:flex;
      justify-content:space-between;
      align-items:center;
      padding:14px 16px;
      gap:12px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      border-bottom:1px solid var(--line);
    }
    .brand{
      display:flex;
      align-items:center;
      gap:10px;
      text-decoration:none;
      min-width:220px;
    }
    .brand img{ height:42px; width:auto; display:block; }
    .brand span{
      font-weight:900;
      color:var(--navy);
      font-size:18px;
      white-space:nowrap;
    }
    .nav{ display:flex; gap:10px; align-items:center; }
    .btn{
      border:1px solid var(--line);
      background:#fff;
      padding:10px 14px;
      border-radius:14px;
      text-decoration:none;
      font-weight:800;
      color:var(--navy);
      display:inline-flex;
      align-items:center;
      gap:8px;
    }
    .btn.primary{
      background:var(--blue);
      color:#fff;
      border-color:transparent;
    }

    .banner{
      text-align:center;
      padding:10px 14px;
      background:var(--soft);
      font-weight:900;
      color:var(--navy);
      border-bottom:1px solid var(--line);
    }
    .banner small{
      display:block;
      font-weight:800;
      color:var(--muted);
      margin-top:2px;
    }

    /* Hero */
    .hero{ padding:22px 18px 8px; text-align:center; }
    .hero h1{ margin:10px 0 6px; font-size:40px; letter-spacing:-.5px; }
    .hero p{ margin:0; color:var(--muted); font-weight:600; }

    /* Mini highlights */
    .highlights{
      max-width:920px;
      margin:14px auto 0;
      padding:0 10px;
      display:grid;
      grid-template-columns:repeat(3,1fr);
      gap:10px;
    }
    .hi{
      border:1px solid var(--line);
      background:#fff;
      border-radius:16px;
      padding:12px 14px;
      text-align:left;
      box-shadow:0 10px 22px rgba(0,0,0,.04);
      cursor:pointer;
    }
    .hi .tag{
      display:inline-block;
      font-size:12px;
      font-weight:900;
      padding:6px 10px;
      border-radius:999px;
      color:#fff;
      margin-bottom:8px;
    }
    .tag.ok{ background:var(--ok); }
    .tag.warn{ background:var(--warn); color:#1f2937; }
    .hi .t{ font-weight:900; margin-bottom:4px; }
    .hi .d{ color:var(--muted); font-weight:600; font-size:13px; }

    /* Chat */
    .chat{ max-width:920px; margin:16px auto 6px; padding:0 10px; }
    .chat-row{ display:flex; gap:10px; align-items:stretch; }
    .chat-row input{
      flex:1;
      border:1px solid var(--line);
      border-radius:16px;
      padding:16px;
      font-size:16px;
      outline:none;
    }
    .chat-row button{
      min-width:120px;
      border:0;
      border-radius:16px;
      background:var(--blue);
      color:#fff;
      font-weight:900;
      cursor:pointer;
      padding:16px 18px;
    }
    .chips{
      display:flex;
      gap:10px;
      flex-wrap:wrap;
      justify-content:center;
      padding:12px 0 0;
    }
    .chip{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:10px 14px;
      font-weight:900;
      color:var(--navy);
      cursor:pointer;
      box-shadow:0 6px 18px rgba(0,0,0,.04);
    }

    .messages{
      max-width:920px;
      margin:14px auto 0;
      padding:0 10px;
      display:flex;
      flex-direction:column;
      gap:10px;
    }
    .msg{
      max-width:85%;
      padding:12px 14px;
      border-radius:16px;
      white-space:pre-wrap;
      line-height:1.35;
    }
    .msg.assistant{ background:#f2f6ff; align-self:flex-start; }
    .msg.user{ background:var(--blue); color:#fff; align-self:flex-end; }

    /* Sections */
    .section{ padding:18px 18px 28px; }
    .section h2{ margin:12px 0 6px; font-size:22px; letter-spacing:-.2px; }
    .section p{ margin:0 0 14px; color:var(--muted); font-weight:600; }

    .grid{ display:grid; grid-template-columns:repeat(3, 1fr); gap:14px; }
    .card{
      border:1px solid var(--line);
      border-radius:18px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      overflow:hidden;
      cursor:pointer;
      box-shadow:0 10px 22px rgba(0,0,0,.05);
      min-height:140px;
    }
    .card .pad{ padding:16px; }
    .kicker{
      display:inline-block;
      font-size:12px;
      font-weight:900;
      color:#fff;
      background:rgba(11,95,255,.92);
      padding:6px 10px;
      border-radius:999px;
      margin-bottom:10px;
    }
    .title{ font-weight:900; font-size:16px; margin-bottom:6px; }
    .desc{ color:var(--muted); font-weight:600; font-size:13px; }

    .list{
      margin-top:14px;
      display:grid;
      grid-template-columns:repeat(2,1fr);
      gap:10px 16px;
      padding:0;
      list-style:none;
    }
    .list li{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:12px 14px;
      font-weight:900;
      color:var(--navy);
    }

    .note{
      margin-top:14px;
      border:1px dashed #c7d6f3;
      background:#f7fbff;
      border-radius:16px;
      padding:14px;
      color:var(--muted);
      font-weight:700;
      font-size:13px;
    }

    /* Mobile */
    @media (max-width: 950px){
      .grid{ grid-template-columns:1fr; }
      .highlights{ grid-template-columns:1fr; }
      .hero h1{ font-size:32px; }
      .chat-row{ flex-direction:column; }
      .chat-row button{ width:100%; }
      .list{ grid-template-columns:1fr; }
      .brand span{ font-size:15px; }
      .brand img{ height:34px; }
      .nav{ gap:8px; }
      .btn{ padding:9px 12px; border-radius:12px; }
    }
  </style>
</head>

<body>
  <div class="wrap">
    <div class="shell">

      <div class="topbar">
        <a class="brand" href="/ai/">
          <img src="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png" alt="WhataShine Logistics">
          <span>WhataShine Logistics</span>
        </a>

        <div class="nav">
          <a class="btn" href="tel:+12145551212">Call Now</a>
          <a class="btn primary" href="/ai/quote.php">Get a Quote</a>
          <a class="btn" href="/ai/portal.php">Client Portal</a>
        </div>
      </div>

      <div class="banner">
        🧼 Floors • Stone • Marble • Countertops
        <small>Restoration • polishing • sealing • maintenance programs</small>
      </div>

      <div class="hero">
        <h1><?php echo $pageTitle; ?></h1>
        <p>Tell us what surface you have and what result you want — we’ll guide the right process.</p>
      </div>

      <div class="highlights">
        <div class="hi" onclick="quick('I need marble polishing in a lobby. What info do you need?')">
          <span class="tag ok">Polish</span>
          <div class="t">Marble / Stone polishing</div>
          <div class="d">Honing • polishing • scratch removal • shine</div>
        </div>
        <div class="hi" onclick="quick('We have tile & grout in guest rooms that needs deep cleaning. Can you help?')">
          <span class="tag warn">Tile</span>
          <div class="t">Tile & grout deep clean</div>
          <div class="d">Guest rooms • bathrooms • common areas</div>
        </div>
        <div class="hi" onclick="quick('We need a floor care program (weekly/monthly). What do you recommend?')">
          <span class="tag ok">Program</span>
          <div class="t">Maintenance programs</div>
          <div class="d">Recurring schedule • budgeting • consistency</div>
        </div>
      </div>

      <!-- Chat -->
      <div class="chat">
        <div class="chat-row">
          <input id="chatInput" placeholder="Type your question here…" />
          <button onclick="sendMessage()">Send</button>
        </div>

        <div class="chips">
          <button class="chip" onclick="quick('Do you do marble polishing and scratch removal?')">Marble polishing</button>
          <button class="chip" onclick="quick('Do you do tile & grout cleaning in rooms/bathrooms?')">Tile & grout</button>
          <button class="chip" onclick="quick('Do you do strip & wax for VCT?')">Strip & wax</button>
          <button class="chip" onclick="quick('How do I get a quote for floor restoration?')">Get a quote</button>
        </div>
      </div>

      <div class="messages" id="messages">
        <div class="msg assistant">
Hi — quick questions so I can route you correctly:
1) What city is the property in?
2) What surface type (marble, terrazzo, tile, VCT, concrete, granite/quartz)?
3) What’s the goal (remove scratches, restore shine, deep clean, protect/seal)?
        </div>
      </div>

      <!-- Services -->
      <div class="section">
        <h2>Core floor & surface services</h2>
        <p>Tap a card to ask about scope, scheduling, or a quote.</p>

        <div class="grid">
          <div class="card" onclick="quick('We need marble/stone restoration. What’s your process and what do you need from us?')">
            <div class="pad">
              <div class="kicker">Stone</div>
              <div class="title">Stone & Marble Restoration</div>
              <div class="desc">Honing • polishing • scratch removal • shine restoration</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you do terrazzo restoration and polishing? What’s needed?')">
            <div class="pad">
              <div class="kicker">Terrazzo</div>
              <div class="title">Terrazzo Polishing</div>
              <div class="desc">Gloss restoration • wear reduction • long-term protection</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you do VCT strip & wax? How many sqft and how long does it take?')">
            <div class="pad">
              <div class="kicker">VCT</div>
              <div class="title">Strip & Wax (VCT)</div>
              <div class="desc">Strip • neutralize • finish coats • burnish</div>
            </div>
          </div>

          <div class="card" onclick="quick('We need tile & grout cleaning in rooms and bathrooms. What info do you need?')">
            <div class="pad">
              <div class="kicker">Tile</div>
              <div class="title">Tile & Grout Deep Cleaning</div>
              <div class="desc">Guest rooms • bathrooms • kitchens • common areas</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you do concrete floor cleaning and polishing?')">
            <div class="pad">
              <div class="kicker">Concrete</div>
              <div class="title">Concrete Cleaning / Polishing</div>
              <div class="desc">Degrease • polish • densify • protect</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you do countertop polishing/sealing (granite/quartz/marble)?')">
            <div class="pad">
              <div class="kicker">Countertops</div>
              <div class="title">Countertop Care</div>
              <div class="desc">Polish • seal • stain reduction • shine upgrade</div>
            </div>
          </div>
        </div>

        <h2 style="margin-top:22px;">What we typically cover</h2>
        <p>Common add-ons and scope items for hotels and commercial sites.</p>

        <ul class="list">
          <li>Lobby & elevator stone polishing</li>
          <li>Hallway floor restoration</li>
          <li>Bathroom tile & grout cleaning</li>
          <li>Spot treatment (stains, etching)</li>
          <li>High-traffic edge work</li>
          <li>Sealing & protective coatings</li>
          <li>Burnishing programs</li>
          <li>Slip-resistance guidance</li>
          <li>Night work scheduling</li>
          <li>Before/after documentation</li>
        </ul>

        <div class="note">
          Fast quote checklist: city + surface type + approx sqft + photos (optional) + timeline + whether the area can be closed off.
        </div>
      </div>

    </div>
  </div>

<script>
function addMessage(text, cls){
  const m = document.createElement("div");
  m.className = "msg " + cls;
  m.textContent = text;
  document.getElementById("messages").appendChild(m);
  return m;
}
function quick(text){
  const input = document.getElementById("chatInput");
  input.value = text;
  sendMessage();
}
async function sendMessage(){
  const input = document.getElementById("chatInput");
  const text = input.value.trim();
  if(!text) return;

  addMessage(text, "user");
  input.value = "";

  const bubble = addMessage("Thinking…", "assistant");

  try {
    const res = await fetch("/ai/api/chat.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ message: text }),
      cache: "no-store"
    });

    const raw = await res.text();

    if (!res.ok) {
      bubble.textContent = "Server error (" + res.status + "):\n" + raw.slice(0, 200);
      return;
    }

    let reply = "";
    try {
      const data = JSON.parse(raw);
      reply = data.reply || "";
    } catch (e) {
      reply = raw;
    }

    bubble.textContent = reply ? reply.replace(/\\n/g, "\n") : "No reply received.";
  } catch (err) {
    bubble.textContent = "Request failed: " + (err?.message || "Unknown error");
  }
}

document.addEventListener("DOMContentLoaded", () => {
  const input = document.getElementById("chatInput");
  if (input) {
    input.addEventListener("keydown", (e) => {
      if (e.key === "Enter") sendMessage();
    });
  }
});
</script>

</body>
</html>
