<?php
// /ai/engineering-equipment.php
$siteName  = "WhataShine Logistics";
$pageTitle = "Engineering & Equipment";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?php echo $siteName; ?> | <?php echo $pageTitle; ?></title>

  <!-- Favicon (update filename if needed) -->
  <link rel="icon" type="image/png" href="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png">

  <style>
    :root{
      --blue:#0b5fff;
      --navy:#0b2b5b;
      --bg:#f3f6fb;
      --card:#ffffff;
      --muted:#4a5b77;
      --line:#e6edf7;
      --soft:#eef4ff;
      --shadow: 0 10px 30px rgba(0,0,0,.07);
      --radius: 16px;
      --ok:#16a34a;
      --warn:#f59e0b;
    }
    *{ box-sizing:border-box; }
    body{
      margin:0;
      font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Arial,sans-serif;
      background:var(--bg);
      color:var(--navy);
    }
    .wrap{ max-width:1100px; margin:18px auto 40px; padding:0 14px; }
    .shell{
      background:var(--card);
      border-radius:18px;
      box-shadow:var(--shadow);
      overflow:hidden;
      border:1px solid var(--line);
    }

    .topbar{
      display:flex;
      justify-content:space-between;
      align-items:center;
      padding:14px 16px;
      gap:12px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      border-bottom:1px solid var(--line);
    }
    .brand{
      display:flex;
      align-items:center;
      gap:10px;
      text-decoration:none;
      min-width:220px;
    }
    .brand img{ height:42px; width:auto; display:block; }
    .brand span{
      font-weight:900;
      color:var(--navy);
      font-size:18px;
      white-space:nowrap;
    }
    .nav{ display:flex; gap:10px; align-items:center; }
    .btn{
      border:1px solid var(--line);
      background:#fff;
      padding:10px 14px;
      border-radius:14px;
      text-decoration:none;
      font-weight:800;
      color:var(--navy);
      display:inline-flex;
      align-items:center;
      gap:8px;
    }
    .btn.primary{
      background:var(--blue);
      color:#fff;
      border-color:transparent;
    }

    .banner{
      text-align:center;
      padding:10px 14px;
      background:var(--soft);
      font-weight:900;
      color:var(--navy);
      border-bottom:1px solid var(--line);
    }
    .banner small{
      display:block;
      font-weight:800;
      color:var(--muted);
      margin-top:2px;
    }

    .hero{ padding:22px 18px 8px; text-align:center; }
    .hero h1{ margin:10px 0 6px; font-size:40px; letter-spacing:-.5px; }
    .hero p{ margin:0; color:var(--muted); font-weight:600; }

    .highlights{
      max-width:920px;
      margin:14px auto 0;
      padding:0 10px;
      display:grid;
      grid-template-columns:repeat(3,1fr);
      gap:10px;
    }
    .hi{
      border:1px solid var(--line);
      background:#fff;
      border-radius:16px;
      padding:12px 14px;
      text-align:left;
      box-shadow:0 10px 22px rgba(0,0,0,.04);
      cursor:pointer;
    }
    .hi .tag{
      display:inline-block;
      font-size:12px;
      font-weight:900;
      padding:6px 10px;
      border-radius:999px;
      color:#fff;
      margin-bottom:8px;
    }
    .tag.ok{ background:var(--ok); }
    .tag.warn{ background:var(--warn); color:#1f2937; }
    .hi .t{ font-weight:900; margin-bottom:4px; }
    .hi .d{ color:var(--muted); font-weight:600; font-size:13px; }

    .chat{ max-width:920px; margin:16px auto 6px; padding:0 10px; }
    .chat-row{ display:flex; gap:10px; align-items:stretch; }
    .chat-row input{
      flex:1;
      border:1px solid var(--line);
      border-radius:16px;
      padding:16px;
      font-size:16px;
      outline:none;
    }
    .chat-row button{
      min-width:120px;
      border:0;
      border-radius:16px;
      background:var(--blue);
      color:#fff;
      font-weight:900;
      cursor:pointer;
      padding:16px 18px;
    }
    .chips{
      display:flex;
      gap:10px;
      flex-wrap:wrap;
      justify-content:center;
      padding:12px 0 0;
    }
    .chip{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:10px 14px;
      font-weight:900;
      color:var(--navy);
      cursor:pointer;
      box-shadow:0 6px 18px rgba(0,0,0,.04);
    }

    .messages{
      max-width:920px;
      margin:14px auto 0;
      padding:0 10px;
      display:flex;
      flex-direction:column;
      gap:10px;
    }
    .msg{
      max-width:85%;
      padding:12px 14px;
      border-radius:16px;
      white-space:pre-wrap;
      line-height:1.35;
    }
    .msg.assistant{ background:#f2f6ff; align-self:flex-start; }
    .msg.user{ background:var(--blue); color:#fff; align-self:flex-end; }

    .section{ padding:18px 18px 28px; }
    .section h2{ margin:12px 0 6px; font-size:22px; letter-spacing:-.2px; }
    .section p{ margin:0 0 14px; color:var(--muted); font-weight:600; }

    .grid{ display:grid; grid-template-columns:repeat(3, 1fr); gap:14px; }
    .card{
      border:1px solid var(--line);
      border-radius:18px;
      background:linear-gradient(180deg,#ffffff,#f8fbff);
      overflow:hidden;
      cursor:pointer;
      box-shadow:0 10px 22px rgba(0,0,0,.05);
      min-height:140px;
    }
    .card .pad{ padding:16px; }
    .kicker{
      display:inline-block;
      font-size:12px;
      font-weight:900;
      color:#fff;
      background:rgba(11,95,255,.92);
      padding:6px 10px;
      border-radius:999px;
      margin-bottom:10px;
    }
    .title{ font-weight:900; font-size:16px; margin-bottom:6px; }
    .desc{ color:var(--muted); font-weight:600; font-size:13px; }

    .list{
      margin-top:14px;
      display:grid;
      grid-template-columns:repeat(2,1fr);
      gap:10px 16px;
      padding:0;
      list-style:none;
    }
    .list li{
      border:1px solid var(--line);
      background:#fff;
      border-radius:14px;
      padding:12px 14px;
      font-weight:900;
      color:var(--navy);
    }

    .note{
      margin-top:14px;
      border:1px dashed #c7d6f3;
      background:#f7fbff;
      border-radius:16px;
      padding:14px;
      color:var(--muted);
      font-weight:700;
      font-size:13px;
    }

    @media (max-width: 950px){
      .grid{ grid-template-columns:1fr; }
      .highlights{ grid-template-columns:1fr; }
      .hero h1{ font-size:32px; }
      .chat-row{ flex-direction:column; }
      .chat-row button{ width:100%; }
      .list{ grid-template-columns:1fr; }
      .brand span{ font-size:15px; }
      .brand img{ height:34px; }
      .nav{ gap:8px; }
      .btn{ padding:9px 12px; border-radius:12px; }
    }
  </style>
</head>

<body>
  <div class="wrap">
    <div class="shell">

      <div class="topbar">
        <a class="brand" href="/ai/">
          <img src="/ai/assets/images/8665d5c3-db3b-43d0-935c-770157a96116.png" alt="WhataShine Logistics">
          <span>WhataShine Logistics</span>
        </a>

        <div class="nav">
          <a class="btn" href="tel:+12145551212">Call Now</a>
          <a class="btn primary" href="/ai/quote.php">Get a Quote</a>
          <a class="btn" href="/ai/portal.php">Client Portal</a>
        </div>
      </div>

      <div class="banner">
        🛠️ Engineering & Equipment Support
        <small>Coordination • Repairs • Parts • Vendor dispatch (as needed)</small>
      </div>

      <div class="hero">
        <h1><?php echo $pageTitle; ?></h1>
        <p>Tell us what’s broken, where it is, and how urgent it is — we’ll route it fast.</p>
      </div>

      <div class="highlights">
        <div class="hi" onclick="quick('We have a machine down (make/model). How fast can you coordinate a repair?')">
          <span class="tag warn">Down</span>
          <div class="t">Equipment down</div>
          <div class="d">Triage • parts • shop coordination</div>
        </div>
        <div class="hi" onclick="quick('We need help sourcing parts for hotel equipment. What do you need?')">
          <span class="tag ok">Parts</span>
          <div class="t">Parts sourcing</div>
          <div class="d">Make/model • photos • serial number</div>
        </div>
        <div class="hi" onclick="quick('We need recurring support for engineering requests. Do you offer a program?')">
          <span class="tag ok">Program</span>
          <div class="t">Ongoing support</div>
          <div class="d">Recurring requests • tracking • coordination</div>
        </div>
      </div>

      <!-- Chat -->
      <div class="chat">
        <div class="chat-row">
          <input id="chatInput" placeholder="Type your question here…" />
          <button onclick="sendMessage()">Send</button>
        </div>

        <div class="chips">
          <button class="chip" onclick="quick('I have a machine down right now. What info do you need?')">Machine down</button>
          <button class="chip" onclick="quick('Can you help source parts?')">Parts</button>
          <button class="chip" onclick="quick('Do you coordinate vendor repairs and pickup/dropoff?')">Coordination</button>
          <button class="chip" onclick="quick('How do I get a quote or service request started?')">Start request</button>
        </div>
      </div>

      <div class="messages" id="messages">
        <div class="msg assistant">
Hi — quick questions so I can route this correctly:
1) What city & property name?
2) What equipment type (HVAC, laundry, kitchen, cleaning machine, pump, etc.)?
3) Is it down now or intermittent, and what’s the urgency (today / this week)?
If you have a make/model or photo, even better.
        </div>
      </div>

      <div class="section">
        <h2>What we handle</h2>
        <p>Tap a card to ask about scope, turnaround, or to start a request.</p>

        <div class="grid">
          <div class="card" onclick="quick('We need repair coordination for equipment. What’s your process?')">
            <div class="pad">
              <div class="kicker">Coordination</div>
              <div class="title">Repair Coordination</div>
              <div class="desc">Triage • scheduling • vendor routing • updates</div>
            </div>
          </div>

          <div class="card" onclick="quick('Can you help pick up / drop off equipment to a repair shop?')">
            <div class="pad">
              <div class="kicker">Transport</div>
              <div class="title">Pickup / Dropoff</div>
              <div class="desc">Move equipment to shop • return to site</div>
            </div>
          </div>

          <div class="card" onclick="quick('We need help sourcing parts. What info do you need?')">
            <div class="pad">
              <div class="kicker">Parts</div>
              <div class="title">Parts Sourcing</div>
              <div class="desc">Make/model • serial • photos • compatible options</div>
            </div>
          </div>

          <div class="card" onclick="quick('Do you coordinate HVAC or building maintenance vendors?')">
            <div class="pad">
              <div class="kicker">Building</div>
              <div class="title">Building Maintenance Vendors</div>
              <div class="desc">HVAC • plumbing • electrical • misc</div>
            </div>
          </div>

          <div class="card" onclick="quick('We need preventative maintenance planning. Can you help?')">
            <div class="pad">
              <div class="kicker">PM</div>
              <div class="title">Preventative Maintenance</div>
              <div class="desc">Recurring checks • logs • tracking</div>
            </div>
          </div>

          <div class="card" onclick="quick('We need emergency support. What’s your fastest path to get help?')">
            <div class="pad">
              <div class="kicker">Urgent</div>
              <div class="title">Emergency Support Intake</div>
              <div class="desc">Rapid triage • priority routing • escalation</div>
            </div>
          </div>
        </div>

        <h2 style="margin-top:22px;">Info that helps us move fastest</h2>
        <p>If you can share any of these, we can usually route it quicker.</p>

        <ul class="list">
          <li>Property + exact location (floor/room)</li>
          <li>Equipment type (HVAC/laundry/kitchen/etc.)</li>
          <li>Make / model / serial number</li>
          <li>What happened + current symptoms</li>
          <li>Photos or short video (if available)</li>
          <li>When it started + urgency</li>
          <li>Access rules (keys, hours, escort)</li>
          <li>Any prior service history</li>
          <li>Preferred vendor (if required)</li>
          <li>PO / billing contact (if needed)</li>
        </ul>

        <div class="note">
          Note: We can coordinate and route support, but final repair scope, pricing, and timelines depend on the vendor/parts availability and site access.
        </div>
      </div>

    </div>
  </div>

<script>
function addMessage(text, cls){
  const m = document.createElement("div");
  m.className = "msg " + cls;
  m.textContent = text;
  document.getElementById("messages").appendChild(m);
  return m;
}
function quick(text){
  const input = document.getElementById("chatInput");
  input.value = text;
  sendMessage();
}
async function sendMessage(){
  const input = document.getElementById("chatInput");
  const text = input.value.trim();
  if(!text) return;

  addMessage(text, "user");
  input.value = "";

  const bubble = addMessage("Thinking…", "assistant");

  try {
    const res = await fetch("/ai/api/chat.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ message: text }),
      cache: "no-store"
    });

    const raw = await res.text();

    if (!res.ok) {
      bubble.textContent = "Server error (" + res.status + "):\n" + raw.slice(0, 200);
      return;
    }

    let reply = "";
    try {
      const data = JSON.parse(raw);
      reply = data.reply || "";
    } catch (e) {
      reply = raw;
    }

    bubble.textContent = reply ? reply.replace(/\\n/g, "\n") : "No reply received.";
  } catch (err) {
    bubble.textContent = "Request failed: " + (err?.message || "Unknown error");
  }
}

document.addEventListener("DOMContentLoaded", () => {
  const input = document.getElementById("chatInput");
  if (input) {
    input.addEventListener("keydown", (e) => {
      if (e.key === "Enter") sendMessage();
    });
  }
});
</script>

</body>
</html>
